const knex = require('../../database/knex.config')()

function gameDataController() {
    return {
        async index(req, res) {
            // const actionGames = await knex('games').where('category', 'Action').orderBy('id', 'desc').limit(5)
            // const adventureGames = await knex('games').where('category', 'Adventure').orderBy('id', 'desc').limit(5)
            // const arcadeGames = await knex('games').where('category', 'Arcade').orderBy('id', 'desc').limit(5)
            // const featuredGames = await knex('games').where('category', 'Featured').orderBy('id', 'desc').limit(3)
            // const populerGames = await knex('games').orderBy('like', 'desc').limit(5)

            const actionGames = await knex('games').orderBy('id', 'desc').limit(6)
            res.render('games/home', { popular: actionGames });
        },
        async moregames(req, res) {
            const actionGames = await knex('games').orderBy('id', 'desc')
            res.render('games/home', { popular: actionGames });

        },
        async gameDetail(req, res) {
            const gameData = await knex("games")
                .where("name", req.params.name)
                .first();

            const populerGames = await knex('games').orderBy('id', 'desc')

            if (!gameData) {
                return res.redirect("/error");
            }

            res.render('games/game-detail', { data: gameData, popular: populerGames });
        },
        async gamePlay(req, res) {
            const gameData = await knex("games")
                .where("name", req.params.name)
                .first();

            if (!gameData) {
                return res.redirect("/error");
            }

            res.render('games/game-play', { data: gameData });
        },
        async searchPage(req, res) {
            var searchQuery = req.query.s;

            if (searchQuery) {
                const term = "%" + searchQuery + "%";
                const gameData = await knex("games").where("name", "like", term)

                return res.render('games/search-page', { data: gameData, name: searchQuery });
            } else {
                const gameData = await knex("games")

                return res.render('games/search-page', { data: gameData, name: searchQuery })
            }
        },
        async privacyPolicyPage(req, res) {
            res.render('games/privacy-policy');
        },
        async aboutUsPage(req, res) {
            res.render('games/about-us');
        },
        async contactUsPage(req, res) {
            res.render('games/contact-us');
        },
        async errorPage(req, res) {
            res.render('games/error');
        },
        async blogOne(req, res) {
            // return res.json("sfsdfdf")
            res.render('games/blog-one');
        }
    }

}

module.exports = gameDataController;